function Dec=FraDec(A,D,L)

% function Dec=FraDec(A,D,L)
% This function implement framelet decomposition.
% A ==== the data to be decomposed, which are in a square matrix.
% D ==== is the decomposition filter in 1D. In 2D, it is generated by tensor
% product. The filter D must be symmetric or anti-symmetric, which
% are indicated by 's' and 'a' respectively in the last cell of D.
% L ==== is the level of the decomposition.
% Dec ==== is the framlet coefficient which are in a cell.

% Written by Jian-Feng Cai.
% email: tslcaij@nus.edu.sg

nD=length(D);
SorAS=D{nD};

for i=1:nD-1
    M1=D{i};
    tempi=ConvSymAsym(A,M1,SorAS(i),L);
    for j=1:nD-1
        M2=D{j};        
        tempj=ConvSymAsym(tempi',M2,SorAS(j),L);
        Dec{i,j}=tempj';
        % Dec{i,j}=ConvSymAsym2D(A,M1,SorAS(i),M2,SorAS(j),L);
    end
end